
'==========================================================================
' Automatic Laser Cycles
'==========================================================================

  GOSUB set_vars
  GOSUB set_params

alp1:
  IF ( (VR(70)<>0) OR (VR(71)<>0) ) THEN VR(198)=0
  IF VR(98)<>0 THEN GOTO do_it
  IF VR(198)=1 THEN GOTO a_start
GOTO alp1

do_it:
  IF VR(198)=1 THEN VR(98)=0:GOTO alp1
  command = VR(98)
  IF ((command >= 10 ) AND (command <= 13)) THEN GOTO ref
  IF (VR(71) AND 1)=0 THEN
     IF ((command >= 1 ) AND (command <= 4)) THEN GOTO flw_err
  ENDIF
GOTO alp1

a_start:

IF IN(estop_reset)=OFF THEN VR(198)=0:GOTO alp1
IF ( (VR(70)<>0) OR (VR(71)<>0) ) THEN VR(198)=0:GOTO alp1
angle=0
lastcode=1
BASE(0)
lx=MPOS  AXIS(0):ly=MPOS  AXIS(1):lz=MPOS  AXIS(2)
x=MPOS  AXIS(0):y=MPOS  AXIS(1):z=MPOS  AXIS(2)

IF VR(10)<>100 THEN
 temp_tab=VR(10)
 temp_blk=VR(11)
 VR(10)=50:VR(11)=VR(11)-8
 IF VR(11)<0 THEN VR(11)=0
blp1:
  '
command = TABLE(VR(10))
 IF command = -9999 THEN
    VR(10)=temp_tab
    VR(11)=temp_blk
    GOTO alp2
 ENDIF
 IF ((command < 1) OR (command > 25)) THEN GOTO comm_err
 IF (command < 18) THEN
 ON command GOSUB a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17
 ELSE
  command=command-17
  ON command GOSUB a18,a19,a20,a21,a22,a23,a24,a25
 ENDIF
 IF VR(104)=-9999 THEN
    VR(104)=0:VR(11)=0:VR(10)=100
    VR(14)=0:VR(15)=0
    GOTO alp1
 ENDIF
 IF VR(198)=0 THEN GOTO alp1
 VR(11)=VR(11)+1
GOTO blp1
ENDIF


alp2:

command = TABLE(VR(10))

IF command = -9999 THEN GOTO prog_end
IF ((command < 1) OR (command > 25)) THEN GOTO comm_err
IF (command < 18) THEN
ON command GOSUB a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17
ELSE
command=command-17
ON command GOSUB a18,a19,a20,a21,a22,a23,a24,a25
ENDIF
IF VR(104)=-9999 THEN
   VR(104)=0:VR(11)=0:VR(10)=100
   VR(14)=0:VR(15)=0
   GOTO alp1
ENDIF
IF VR(198)=0 THEN GOTO alp1
VR(11)=VR(11)+1
GOTO alp2

prog_end:
  boff=VR(26)
  VR(10)=100
  VR(11)=0
  VR(14)=0:VR(15)=0
  VR(198)=0
  IF VR(202)=0 THEN GOTO alp1
  VR(201)=VR(201)+1
  WHILE MTYPE  AXIS(0)>0
  WEND
  IF (VR(201)>=VR(202)) THEN VR(71)=(VR(71) OR 512)
GOTO alp1

' ----------------------------------------------------------------

comm_err:
  ' Set "Invalid Command" error
  VR(198)=0
  VR(71)=(VR(71) OR 128)
  VR(10)=100:VR(11)=0
GOTO alp1

' ----------------------------------------------------------------

' MOVE
a1:
  x=TABLE(VR(10)+1)
  y=TABLE(VR(10)+2)
  z=TABLE(VR(10)+3)
  m=TABLE(VR(10)+4)
  'IF TABLE(VR(10)+5)=-9999 THEN VR(14)=0:VR(15)=0
  IF x=-9999 THEN
     x=lx
  ELSE
     x=x+VR(14)
  ENDIF
  IF y=-9999 THEN
     y=ly
  ELSE
     y=y+VR(15)
  ENDIF
  IF z=-9999 THEN
     z=lz
  ELSE
     z=z+VR(16)
  ENDIF
  feed_set=VR(13)
  IF (VR(197)=1) THEN WAIT UNTIL ((VR(104)=-9999) OR (VR(197)=0))
  IF VR(104)=-9999 THEN RETURN

  ' check for clamp interference

  s=feed_set
  s=(s/(100/VR(18)))
  acl=VR(24)

  WAIT UNTIL ((NTYPE  AXIS(0)=0) OR (VR(104)=-9999))
  IF ((VR(90)=0) OR (VR(90)=-88)) THEN
     WAIT UNTIL ((MTYPE  AXIS(2)=0) OR (VR(104)=-9999))
  ENDIF
  IF VR(104)=-9999 THEN RETURN
  BASE(0)
  VR(8)=s
  SPEED  AXIS(0)=VR(8)
  merge axis(0)=m
  merge axis(1)=m
  
  IF ((VR(90)=0) OR (VR(90)=-88)) THEN
     Ma (x,y,z)
  ELSE
     Ma (x,y)
  ENDIF
  VR(10)=VR(10)+5
  lx=x
  ly=y
  lz=z
RETURN

' CUT LINE
a2:
  x=TABLE(VR(10)+1)
  y=TABLE(VR(10)+2)
  z=TABLE(VR(10)+3)
  m=TABLE(VR(10)+4)
  IF TABLE(VR(10)+5)=-9999 THEN VR(14)=0:VR(15)=0
  IF x=-9999 THEN
     x=lx
  ELSE
     x=x+VR(14)
  ENDIF
  IF y=-9999 THEN
     y=ly
  ELSE
     y=y+VR(15)
  ENDIF
  IF z=-9999 THEN
     z=lz
  ELSE
     z=z+VR(16)
  ENDIF
  feed_set=VR(17)
  GOSUB motion
  VR(10)=VR(10)+5
  lx=x
  ly=y
  lz=z
RETURN


' ARC CW
a3:
  x=TABLE(VR(10)+1)
  y=TABLE(VR(10)+2)
  i=TABLE(VR(10)+3)
  j=TABLE(VR(10)+4)
  m=TABLE(VR(10)+5)
  IF x=-9999 THEN
     nx=0:x=lx
  ELSE
     x=x+VR(14)
     nx=x-lx
  ENDIF
  IF y=-9999 THEN
     ny=0:y=ly
  ELSE
     y=y+VR(15)
     ny=y-ly
  ENDIF
  IF i=-9999 THEN i=0
  IF j=-9999 THEN j=0
  WAIT UNTIL NTYPE  AXIS(0)=0 OR VR(104)=-9999
  IF VR(104)=-9999 THEN RETURN
  MERGE  AXIS(0)=m
  MERGE  AXIS(1)=m
  s=VR(17)
  s=(s/(100/VR(18)))
  VR(8)=s
  SPEED  AXIS(0)=VR(8)
  MOVECIRC(nx,ny,i,j,0)
  VR(10)=VR(10)+6
  lx=x
  ly=y
RETURN

' ARC CCW
a4:
  x=TABLE(VR(10)+1)
  y=TABLE(VR(10)+2)
  i=TABLE(VR(10)+3)
  j=TABLE(VR(10)+4)
  m=TABLE(VR(10)+5)
  IF x=-9999 THEN
     nx=0 :x=lx
  ELSE
     x=x+VR(14)
     nx=x-lx
  ENDIF
  IF y=-9999 THEN
     ny=0:y=ly
  ELSE
     y=y+VR(15)
     ny=y-ly
  ENDIF
  IF i=-9999 THEN i=0
  IF j=-9999 THEN j=0
  WAIT UNTIL NTYPE  AXIS(0)=0 OR VR(104)=-9999
  IF VR(104)=-9999 THEN RETURN
  MERGE  AXIS(0)=m
  MERGE  AXIS(1)=m
  s=VR(17)
  s=(s/(100/VR(18)))
  VR(8)=s
  SPEED  AXIS(0)=VR(8)
  MOVECIRC(nx,ny,i,j,1)
  VR(10)=VR(10)+6
  lx=x
  ly=y
RETURN

' PROGRAM STOP
a5:
  WAIT UNTIL ((NTYPE  AXIS(0)=0) OR (VR(104)=-9999))
  WAIT UNTIL ((MTYPE  AXIS(0)=0) OR (VR(104)=-9999))
  IF VR(104)=-9999 THEN RETURN
  VR(71)=VR(71) OR 64:VR(197)=1
  WAIT UNTIL VR(197)=0
  VR(10)=VR(10)+1
RETURN

' DWELL
a6:
  WAIT UNTIL ((NTYPE  AXIS(0)=0) OR (VR(104)=-9999))
  WAIT UNTIL ((MTYPE  AXIS(0)=0) OR (VR(104)=-9999))
  IF VR(104)=-9999 THEN RETURN
  tmp=VR(91)
  vr(91)=0
  d=TABLE(VR(10)+1)
  IF d=99 THEN d=pierce ELSE d=d*1000
  WA(d)
  vr(91)=tmp
  VR(10)=VR(10)+2
RETURN

' PROFILER
a7:
  ' for SA250 laser only
  WAIT UNTIL ((NTYPE  AXIS(0)=0) OR (VR(104)=-9999))
  WAIT UNTIL ((MTYPE=0) OR (VR(104)=-9999))
  IF VR(104)=-9999 THEN RETURN
  VR(90) = TABLE(VR(10)+1) ' vr(90)=global for profiler task
  temp=VR(90)
  IF temp=0 THEN WAIT UNTIL VR(90)=-88
  IF temp=1 THEN WAIT UNTIL VR(90)=-99
  IF temp=0 THEN VR(90)=0
  lz=MPOS  AXIS(2)
  VR(10)=VR(10)+2
RETURN

' COMPENSATION
a8:
VR(10)=VR(10)+2
RETURN

' HEAD CONTROL
a9:
  IF TABLE(VR(10)+1)=1 THEN VR(2)=1 ELSE VR(2)=2
  WAIT UNTIL (VR(2)=0)
  VR(10)=VR(10)+2
RETURN

' LASER POWER
a10:
  WAIT UNTIL ((NTYPE  AXIS(0)=0) OR (VR(104)=-9999))
  WAIT UNTIL ((MTYPE=0) OR (VR(104)=-9999))
  IF VR(104)=-9999 THEN RETURN
  pwr = TABLE(VR(10)+1)
  VR(95)=pwr
  VR(10)=VR(10)+2
RETURN

' RAMPING
a11:
  WAIT UNTIL ((NTYPE  AXIS(0)=0) OR (VR(104)=-9999))
  WAIT UNTIL ((MTYPE=0) OR (VR(104)=-9999))
  IF VR(104)=-9999 THEN RETURN
  r = TABLE(VR(10)+1) ' global for ramping task
  'IF r=0 THEN r=1 ELSE r=0
  VR(91)=r
  VR(10)=VR(10)+2
RETURN

' LASER PULSE
a12:
  WAIT UNTIL ((NTYPE  AXIS(0)=0) OR (VR(104)=-9999))
 WAIT UNTIL ((MTYPE=0) OR (VR(104)=-9999))
 IF VR(104)=-9999 THEN RETURN
 p=TABLE(VR(10)+1)
 IF p=0 THEN OP(pulse,1):OP(pulse+1,1)
 IF p=1 THEN OP(pulse,1):OP(pulse+1,0)
 IF p=2 THEN OP(pulse,0):OP(pulse+1,1)
 IF p=3 THEN OP(pulse,0):OP(pulse+1,0)
 VR(10)=VR(10)+2
RETURN

' FEEDRATE
a13:
 WAIT UNTIL ((NTYPE  AXIS(0)=0) OR (VR(104)=-9999))
 WAIT UNTIL ((MTYPE=0) OR (VR(104)=-9999))
 IF VR(104)=-9999 THEN RETURN
 feed=TABLE(VR(10)+1)/60
 VR(17)=feed
 VR(10)=VR(10)+2
RETURN

' ACC/DEC
a14:
VR(10)=VR(10)+2
RETURN

' AXIS OFFSET
a15:
  WAIT UNTIL ((NTYPE  AXIS(0)=0) OR (VR(104)=-9999))
  WAIT UNTIL MTYPE  AXIS(0)=0 OR VR(104)=-9999
  IF VR(104)=-9999 THEN RETURN
  ox=TABLE(VR(10)+1)
  oy=TABLE(VR(10)+2)
  oz=TABLE(VR(10)+3)
  IF ox=-999 THEN
    VR(14)=0:VR(15)=0:VR(16)=0
  ELSE
    IF ox<>-9999 THEN
       VR(14)=x-ox
       lx=lx+ox
    ENDIF
    IF oy<>-9999 THEN
       VR(15)=y-oy
       ly=ly+oy
    ENDIF
    IF oz<>-9999 THEN
       VR(16)=z-oz
       lz=lz+oz
    ENDIF
  ENDIF
  VR(10)=VR(10)+4
RETURN

' LASER SETTING
a16:
  WAIT UNTIL ((NTYPE  AXIS(0)=0) OR (VR(104)=-9999))
  WAIT UNTIL ((MTYPE=0) OR (VR(104)=-9999))
  IF VR(104)=-9999 THEN RETURN
  state = TABLE(VR(10)+1)
  OP(ramp_up,ON)
  OP(laser,state)
  VR(10)=VR(10)+2
RETURN

' PIERCE-TIME
a17:
  WAIT UNTIL ((NTYPE  AXIS(0)=0) OR (VR(104)=-9999))
 WAIT UNTIL ((MTYPE=0) OR (VR(104)=-9999))
 IF VR(104)=-9999 THEN RETURN
 pierce=TABLE(VR(10)+1)*1000
 VR(10)=VR(10)+2
RETURN

' CUTTING GAS
a18:
 WAIT UNTIL ((NTYPE  AXIS(0)=0) OR (VR(104)=-9999))
 WAIT UNTIL ((MTYPE=0) OR (VR(104)=-9999))
 IF VR(104)=-9999 THEN RETURN
 d=TABLE(VR(10)+1)
 OP(gas1,OFF):OP(gas2,OFF):OP(gas3,OFF):OP(gas4,OFF)
 IF d>0 THEN OP(gas1+(d-1),ON)
 WA(200)
 VR(10)=VR(10)+2
RETURN

' RAPID FEEDRATE
a19:
 WAIT UNTIL ((NTYPE  AXIS(0)=0) OR (VR(104)=-9999))
 WAIT UNTIL ((MTYPE=0) OR (VR(104)=-9999))
 IF VR(104)=-9999 THEN RETURN
 rapid=TABLE(VR(10)+1)/60
 VR(13)=rapid
 VR(10)=VR(10)+2
RETURN

' FREQUENCY
a20:
 WAIT UNTIL ((NTYPE  AXIS(0)=0) OR (VR(104)=-9999))
 WAIT UNTIL ((MTYPE=0) OR (VR(104)=-9999))
 IF VR(104)=-9999 THEN RETURN
 freq=TABLE(VR(10)+1)
 IF freq>99 THEN freq=99
 IF freq>=80 THEN freq=freq-80:OP(70,ON) ELSE OP(70,OFF)
 IF freq>=40 THEN freq=freq-40:OP(69,ON) ELSE OP(69,OFF)
 IF freq>=20 THEN freq=freq-20:OP(68,ON) ELSE OP(68,OFF)
 IF freq>=10 THEN freq=freq-10:OP(67,ON) ELSE OP(67,OFF)
 IF freq>=8 THEN freq=freq-8:OP(66,ON) ELSE OP(66,OFF)
 IF freq>=4 THEN freq=freq-4:OP(65,ON) ELSE OP(65,OFF)
 IF freq>=2 THEN freq=freq-2:OP(64,ON) ELSE OP(64,OFF)
 IF freq>=1 THEN freq=freq-1:OP(63,ON) ELSE OP(63,OFF)
 VR(10)=VR(10)+2
RETURN

' RAMP MINIMUM
a21:
 WAIT UNTIL ((NTYPE  AXIS(0)=0) OR (VR(104)=-9999))
 WAIT UNTIL ((MTYPE=0) OR (VR(104)=-9999))
 IF VR(104)=-9999 THEN RETURN
 VR(92)=TABLE(VR(10)+1)
 VR(10)=VR(10)+2
RETURN

' SHUTTER OPERATION
a22:
 WAIT UNTIL ((NTYPE  AXIS(0)=0) OR (VR(104)=-9999))
 WAIT UNTIL ((MTYPE=0) OR (VR(104)=-9999))
 IF VR(104)=-9999 THEN RETURN
 state = TABLE(VR(10)+1)
 OP(shutter,state)
 VR(10)=VR(10)+2
RETURN

' REPOSITION
a23:
  VR(10)=VR(10)+5
RETURN

' DUTY
a24:
 WAIT UNTIL ((NTYPE  AXIS(0)=0) OR (VR(104)=-9999))
 WAIT UNTIL ((MTYPE=0) OR (VR(104)=-9999))
 IF VR(104)=-9999 THEN RETURN
 duty=TABLE(VR(10)+1)
 IF duty<3 THEN duty=3
 IF duty>97 THEN duty=97
 IF duty>=80 THEN duty=duty-80:OP(60,ON) ELSE OP(60,OFF)
 IF duty>=40 THEN duty=duty-40:OP(59,ON) ELSE OP(59,OFF)
 IF duty>=20 THEN duty=duty-20:OP(58,ON) ELSE OP(58,OFF)
 IF duty>=10 THEN duty=duty-10:OP(57,ON) ELSE OP(57,OFF)
 IF duty>=8 THEN duty=duty-8:OP(56,ON) ELSE OP(56,OFF)
 IF duty>=4 THEN duty=duty-4:OP(55,ON) ELSE OP(55,OFF)
 IF duty>=2 THEN duty=duty-2:OP(54,ON) ELSE OP(54,OFF)
 IF duty>=1 THEN duty=duty-1:OP(53,ON) ELSE OP(53,OFF)
 VR(10)=VR(10)+2
RETURN


' SUBROUTINES
a25:
 sbx=TABLE(VR(10)+1)
 sby=TABLE(VR(10)+2)
 sbi=TABLE(VR(10)+3)
 sbj=TABLE(VR(10)+4)
 sbp=TABLE(VR(10)+5)
 sbq=TABLE(VR(10)+6)
 sbf=TABLE(VR(10)+7)
 sbs=TABLE(VR(10)+8)
 l=1
 FOR lp=1 TO 50
   IF sbs=TABLE(l) THEN
      last_pointer=VR(10)+9
      last_block=VR(11)
      st=TABLE(l+1)
      VR(10)=INT(st)
      VR(11)=INT((st-VR(10))*100)+1
      tempt=VR(10)
      tempb=VR(11)
      lp=50
   ELSE
      l=l+2
   ENDIF
 NEXT lp
exit:
IF sbi=-9999 THEN sbi=0
IF sbj=-9999 THEN sbj=0
IF sbp=-9999 THEN sbp=1
IF sbq=-9999 THEN sbq=1
IF sbf=1 THEN
   tj=sbj
   tq=sbq
   sbj=sbi
   sbq=sbp
   sbi=tj
   sbp=tq
ENDIF
tx=VR(14)
ty=VR(15)
ltx=0:lty=0
sbx1=sbx+(sbi*(sbp-1))
sbx2=sbx
sby1=sby+(sbi*(sbp-1))
sby2=sby
FOR yy=0 TO sbq -1
 FOR xx=0 TO sbp-1
   WAIT UNTIL ((NTYPE  AXIS(0)=0) OR (VR(104)=-9999))
   WAIT UNTIL ((MTYPE  AXIS(0)=0) OR (VR(104)=-9999))
   IF VR(104)=-9999 THEN
      VR(104)=0:VR(11)=0:VR(10)=100
      VR(14)=0:VR(15)=0
      GOTO exit_lp
   ENDIF
   VR(10)=tempt
   VR(11)=tempb
   IF sbf<>1 THEN
      VR(14)=tx+(sbx+(xx*sbi))
      VR(15)=ty+(sby+(yy*sbj))
   ELSE
      VR(14)=tx+(sbx+(yy*sbj))
      VR(15)=ty+(sby+(xx*sbi))
   ENDIF
   IF ltx<>VR(14) THEN
'      lx=lx+(VR(14)-ltx)
      ltx=VR(14)
   ENDIF
   IF lty<>VR(15) THEN
'      ly=ly+(VR(15)-lty)
      lty=VR(15)
   ENDIF
lp2:
   command = TABLE(VR(10))
   IF command = -9999 THEN GOTO lfin
   IF ((command < 1) OR (command > 25)) THEN GOTO comm_err
   IF (command < 18) THEN
 ON command GOSUB a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17
   ELSE
     command=command-17
     ON command GOSUB a18,a19,a20,a21,a22,a23,a24,a25
   ENDIF
   IF VR(104)=-9999 THEN
      VR(104)=0:VR(11)=0:VR(10)=100
      VR(14)=0:VR(15)=0
      VR(104)=-9999
      GOTO exit_lp
   ENDIF
   IF VR(198)=0 THEN GOTO exit_lp
   VR(11)=VR(11)+1
   GOTO lp2
lfin:
 NEXT xx
 IF sbf<>1 THEN
    IF sbi>0 THEN
       sbx=sbx1
    ELSE
       sbx=sbx2
    ENDIF
 ELSE
    IF sbi>0 THEN
       sby=sby1
    ELSE
       sby=sby2
    ENDIF
 ENDIF
 sbi=0-sbi
NEXT yy
VR(10)=last_pointer
VR(11)=last_block
VR(14)=tx
VR(15)=ty
RETURN

exit_lp:
xx=sbp-1
yy=sbq-1
GOTO lfin

'______________________________________________________


motion:
  IF (VR(197)=1) THEN WAIT UNTIL ((VR(104)=-9999) OR (VR(197)=0))
  IF VR(104)=-9999 THEN RETURN

  ' check for clamp interference

  s=feed_set
  s=(s/(100/VR(18)))
  acl=VR(24)

  WAIT UNTIL ((NTYPE  AXIS(0)=0) OR (VR(104)=-9999))
  IF ((VR(90)=0) OR (VR(90)=-88)) THEN
     WAIT UNTIL ((MTYPE  AXIS(2)=0) OR (VR(104)=-9999))
  ENDIF
  IF VR(104)=-9999 THEN RETURN
  BASE(0)
  VR(8)=s
  SPEED  AXIS(0)=VR(8)
  merge axis(0)=m
  merge axis(1)=m

  IF ((VR(90)=0) OR (VR(90)=-88)) THEN
     MOVE (x-lx,y-ly,z-lz)
  ELSE
     MOVE (x-lx,y-ly)
  ENDIF

RETURN

' ----------------------------------------------------------------

'==========================================================================
' Main referencing of axis
'==========================================================================

'--------------------------------------------------------------------------

'--------------------------------------------------------------------------

ref:
  IF IN(estop_reset)=OFF THEN command=0:VR(98)=0:GOTO alp1
  IF (command=10) THEN GOSUB ref_all
  IF (command=11) THEN GOSUB ref_x
  IF (command=12) THEN GOSUB ref_y
  IF (command=13) THEN GOSUB ref_z
  command=0 : VR(98)=0
GOTO alp1

'==========================================================================
' DATUM Routines
'==========================================================================

ref_all:
  GOSUB ref_z
  GOSUB ref_x
  GOSUB ref_y
  GOSUB ref_z
  bit=VR(7)-(1+2+4+8)
  VR(71)=VR(71) AND bit
  bit=VR(7)-(1+2+4+8)
  VR(71)=VR(71) AND bit
RETURN

'--------------------------------------------------------------------------

ref_z:
  BASE(2)
  IF IN(z_datum)=OFF THEN
     DEFPOS (-100)
  ELSE
     DEFPOS (-250)
  ENDIF
  VR(71)=VR(71) OR 4
  VR(9)=(VR(29))
  SPEED=VR(9)
  CREEP=VR(37)
  DATUM_IN=z_datum
  DATUM(5)
  WA(5)
  WAIT IDLE
  DEFPOS (VR(32))
  CANCEL
  VR(9)=VR(22)
  SPEED=VR(9)
  MOVEABS(0)
  WA(10)
  WAIT UNTIL MTYPE=0
  bit=VR(7)-4
  VR(71)=VR(71) AND bit
  lz = MPOS  AXIS(2)
  BASE(0)
RETURN

ref_x:
  BASE(0)
  IF IN(x_datum)=OFF THEN
     DEFPOS (2450)
  ELSE
     DEFPOS (2500)
  ENDIF
  VR(71)=VR(71) OR 1
  VR(8)=(VR(29))
  SPEED  AXIS(0)=VR(8)
  CREEP=VR(37)
  DATUM_IN=x_datum
  DATUM(6)
  WA(5)
  WAIT IDLE
  DEFPOS(VR(30))
  CANCEL
  VR(8)=VR(22)
  SPEED=VR(8)
  MOVEABS(0)
  WA(10)
  WAIT UNTIL MTYPE=0
  bit=VR(7)-1
  VR(71)=VR(71) AND bit
  lx = MPOS  AXIS(0)
RETURN

ref_y:
  BASE(1)
  IF IN(y_datum)=OFF THEN
     DEFPOS (1200)
  ELSE
     DEFPOS (1250)
  ENDIF
  VR(71)=VR(71) OR 2
  VR(8)=(VR(29))
  CREEP=VR(37)
  DATUM_IN=y_datum
  DATUM(6)
  WA(5)
  WAIT IDLE
  DEFPOS(VR(31))
  CANCEL
  VR(8)=VR(22)
  SPEED=VR(8)
  MOVEABS(0)
  WA(10)
  WAIT UNTIL MTYPE=0
  WA(300)
  bit=VR(7)-2
  VR(71)=VR(71) AND bit
  ly = MPOS  AXIS(1)
  BASE(0)
RETURN

'--------------------------------------------------------------------------

flw_err:

ON (command) GOTO fol_x, fol_y, fol_z, fol_xy

fol_x:
  BASE(0)
  VR(8)=VR(22)
  SP(VR(8))
  MOVEABS(0)
  WAIT UNTIL (MTYPE=0 OR VR(98)=-1)
  IF VR(98)=-1 THEN GOTO abort_err
  MOVEABS(600)
  WAIT UNTIL (MTYPE=0 OR VR(98)=-1)
  IF VR(98)=-1 THEN GOTO abort_err
GOTO fol_x

fol_y:
  BASE(1)
  VR(8)=VR(22)
  SP(VR(8))
  MOVEABS(0)
  WAIT UNTIL (MTYPE=0 OR VR(98)=-1)
  IF VR(98)=-1 THEN GOTO abort_err
  MOVEABS(600)
  WAIT UNTIL (MTYPE=0 OR VR(98)=-1)
  IF VR(98)=-1 THEN GOTO abort_err
GOTO fol_y

fol_z:
  BASE(2)
  VR(8)=VR(22)
  SP(VR(8))
  MOVEABS(0)
  WAIT UNTIL (MTYPE=0 OR VR(98)=-1)
  IF VR(98)=-1 THEN GOTO abort_err
  MOVEABS(-100)
  WAIT UNTIL (MTYPE=0 OR VR(98)=-1)
  IF VR(98)=-1 THEN GOTO abort_err
GOTO fol_z

fol_xy:
  BASE(0)
  VR(8)=(VR(22)*1.414)
  SP(VR(8))
  MOVEABS(0,0)
  WAIT UNTIL (MTYPE=0 OR VR(98)=-1)
  IF VR(98)=-1 THEN GOTO abort_err
fol_xy1:
  MOVE(600,600)
  WAIT UNTIL (MTYPE=0 OR VR(98)=-1)
  IF VR(98)=-1 THEN GOTO abort_err
  MOVEABS(VR(30)-20,VR(31)-20)
  WAIT UNTIL (MTYPE=0 OR VR(98)=-1)
  IF VR(98)=-1 THEN GOTO abort_err
GOTO fol_xy1

abort_err:
  CANCEL
  CANCEL
  CANCEL
  VR(98)=0
GOTO alp1
'--------------------------------------------------------------------------

'--------------------------------------------------------------------------

set_vars:
 feed=3500/60
 rapid=15000/60
 VR(17)=feed
 VR(13)=rapid
 duty_out = 53
 freq_out = 63
 pulse = 61
 x_clamp = 100
 y_clamp = 100
 load_pos = 0
 x_overtravel = 18
 y_overtravel = 19
 z_overtravel = 20
 x_overtemp = 22
 y_overtemp = 23
 z_overtemp = 24
 safety_mat = 27
 lh_soc = 34
 rh_soc = 35
 ramp_up = 52
 laser = 71
 shutter = 72
 x_axis = 0
 y_axis = 1
 z_axis = 2
 x_datum = 4
 y_datum = 5
 z_datum = 6
 cyclestart = 0
 feedhold = 1
 cs_lamp = 38
 fh_lamp = 39
 laser_door = 21
 mc_door = 26
 gas1 = 11
 gas2 = 12
 gas3 = 13
 gas4 = 14
 estop_reset=28
 single_block = 3
 lastcode=1
 VR(18)=100
 VR(91)=0
 VR(98)=0
 VR(71)=7
 VR(72)=7
 VR(105)=51
RETURN

set_params:
  BASE(x_axis)
  P_GAIN = 0.5
  UNITS = 500
  SP(100)
  ACCEL = 500
  DECEL = 500
  FE_LIMIT = 1000000
  SERVO=ON
  '-----------------------------
  BASE(y_axis)
  P_GAIN = 0.5
  UNITS = 500
  SP(100)
  ACCEL = 2000
  DECEL = 2000
  FE_LIMIT = 1000000
  SERVO=ON
  '-----------------------------
  BASE(z_axis)
  P_GAIN = 0.5
  UNITS = 1000
  SP(100)
  ACCEL = 4000
  DECEL = 4000
  FE_LIMIT = 1000000
  SERVO=ON
  '-----------------------------
  WDOG=ON
  BASE(0)
RETURN
'--------------------------------------------------------------------------
